# 機能設計書 120-Boosted Trees操作

## 概要

本ドキュメントは、TensorFlowにおける勾配ブースティング決定木の学習・推論操作の設計を記述する。

### 本機能の処理概要

勾配ブースティング決定木（Gradient Boosted Decision Trees, GBDT）の学習・推論に必要な一連の操作を提供する。アンサンブルの管理、最適分割点の計算、統計量の集約、量子化（バケット化）、推論実行など、GBDTの全ライフサイクルをカバーする。

**業務上の目的・背景**：勾配ブースティング決定木は、表形式データに対する分類・回帰タスクにおいて非常に高い予測性能を発揮する手法である。Kaggle等のコンペティションでも頻繁に上位を占めており、金融（信用スコアリング）、広告（CTR予測）、医療（診断支援）など幅広い分野で利用される。TensorFlowのBoosted Trees実装により、大規模データに対するスケーラブルな学習が可能。

**機能の利用シーン**：表形式データの分類・回帰、特徴量の重要度分析、モデルの解釈性が求められるアプリケーション、TensorFlowのEstimator API経由でのGBDT学習・推論で利用される。

**主要な処理内容**：
1. TreeEnsembleリソース管理 - ツリーアンサンブルの生成・初期化・シリアライゼーション
2. 最適分割計算 - 各ノードの最適分割点・分割ゲインの計算
3. 統計量集約 - ノードごとの勾配・ヘシアン統計の集約
4. 量子化（バケット化） - 連続値特徴量のバケット境界計算と離散化
5. 推論実行 - 学習済みアンサンブルによる推論
6. アンサンブル更新 - 新しい木の追加・プルーニング

**関連システム・外部連携**：TensorFlowのEstimator API（BoostedTreesClassifier/Regressor）、チェックポイント保存・復元と連携する。

**権限による制御**：特になし。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| - | 該当なし | - | 本機能はバックエンドAPI機能 |

## 機能種別

計算処理 / 機械学習アルゴリズム

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| tree_ensemble_handle | resource | Yes | ツリーアンサンブルリソースハンドル | スカラー |
| node_ids | Tensor（int32） | Yes（統計集約時） | 各データ点が属するノードID | ランク1 |
| gradients | Tensor（float32） | Yes（統計集約時） | 勾配テンソル | ランク2 |
| hessians | Tensor（float32） | Yes（統計集約時） | ヘシアンテンソル | ランク2 |
| bucketized_features | list of Tensor（int32） | Yes（推論時） | バケット化された特徴量 | 各特徴量はランク1-2 |
| l1 | Tensor（float） | Yes（分割計算時） | L1正則化パラメータ | スカラー |
| l2 | Tensor（float） | Yes（分割計算時） | L2正則化パラメータ | スカラー |
| tree_complexity | Tensor（float） | Yes（分割計算時） | ツリー複雑度ペナルティ | スカラー |
| min_node_weight | Tensor（float） | Yes（分割計算時） | 最小ノード重み | スカラー |
| logits_dimension | int | Yes（一部Op） | ロジットの次元数 | >= 1 |
| max_splits | int | Yes（統計集約時） | 最大分割ノード数 | >= 1 |
| num_buckets | int | Yes（統計集約時） | バケット数 | >= 1 |
| epsilon | Tensor（float） | Yes（量子化時） | 量子化近似パラメータ | スカラー |
| pruning_mode | int | Yes（更新時） | プルーニングモード（0: none, 1: pre, 2: post） | >= 0 |

### 入力データソース

Python API呼び出し（TensorFlow Estimator API経由）

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| logits | Tensor（float32） | 推論結果のロジット（バッチサイズ x logits_dimension） |
| node_ids | Tensor（int32） | 最適分割のノードID |
| gains | Tensor（float32） | 各分割のゲイン値 |
| thresholds | Tensor（int32） | 分割閾値 |
| left_node_contribs | Tensor（float32） | 左子ノードの寄与 |
| right_node_contribs | Tensor（float32） | 右子ノードの寄与 |
| stats_summary | Tensor（float32） | 集約された統計量 |
| bucket_boundaries | list of Tensor（float32） | バケット境界値 |
| stamp_token | Tensor（int64） | アンサンブルのスタンプトークン |
| tree_ensemble_serialized | Tensor（string） | シリアライズされたアンサンブル |

### 出力先

呼び出し元への戻り値として返却、またはチェックポイントへの保存

## 処理フロー

### 処理シーケンス

```
1. リソース初期化
   └─ BoostedTreesEnsembleResource / BoostedTreesQuantileStreamResource の生成
   └─ BoostedTreesCreateEnsemble でアンサンブル初期化

2. 特徴量の量子化
   └─ BoostedTreesMakeQuantileSummaries で量子サマリー生成
   └─ BoostedTreesQuantileStreamResourceFlush でバケット境界確定
   └─ BoostedTreesBucketize で特徴量をバケットIDに変換

3. 統計量集約
   └─ BoostedTreesMakeStatsSummary / BoostedTreesAggregateStats
   └─ ノードID × 特徴量 × バケットごとに勾配・ヘシアンを集約

4. 最適分割計算
   └─ BoostedTreesCalculateBestFeatureSplit / V2
   └─ 各ノード×特徴量で最適分割を計算（inequality/equality分割）
   └─ ゲイン、閾値、左右子ノード寄与を出力

5. アンサンブル更新
   └─ BoostedTreesUpdateEnsemble / V2
   └─ 最適分割に基づきツリーを拡張
   └─ プルーニングモード（none/pre/post）に基づき剪定

6. 推論
   └─ BoostedTreesPredict / BoostedTreesTrainingPredict
   └─ バケット化特徴量を使用してツリーを走査しロジット出力

7. シリアライゼーション
   └─ BoostedTreesSerializeEnsemble / BoostedTreesDeserializeEnsemble
   └─ チェックポイント保存・復元
```

### フローチャート

```mermaid
flowchart TD
    A[特徴量データ] --> B[量子化/バケット化]
    B --> C[統計量集約]
    C --> D[最適分割計算]
    D --> E{プルーニング}
    E -->|none| F[アンサンブル更新]
    E -->|pre/post| G[剪定後に更新]
    F --> H{収束?}
    G --> H
    H -->|No| C
    H -->|Yes| I[推論実行]
    I --> J[ロジット出力]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-120-01 | プルーニングモード | 0: なし、1: 事前剪定、2: 事後剪定 | アンサンブル更新時 |
| BR-120-02 | 正則化 | L1/L2正則化とtree_complexityペナルティで過学習を防止 | 分割計算時 |
| BR-120-03 | 分割タイプ | inequality（不等式）とequality（等式）の2種類 | BoostedTreesCalculateBestFeatureSplit |
| BR-120-04 | スタンプトークン | アンサンブルの版管理にスタンプトークンを使用 | シリアライゼーション時 |
| BR-120-05 | 量子化精度 | epsilonパラメータで量子化の近似精度を制御 | バケット境界計算時 |
| BR-120-06 | マルチクラス対応 | logits_dimension属性でマルチクラス分類に対応 | 推論・分割計算時 |
| BR-120-07 | センタリングバイアス | BoostedTreesCenterBiasで初期バイアスを計算 | 学習開始時 |

### 計算ロジック

- **分割ゲイン**: `gain = left_gain + right_gain - parent_gain - tree_complexity`
- **左/右ゲイン**: `gain = (sum_gradients)^2 / (sum_hessians + l2) - l1_penalty`
- **推論**: ツリーアンサンブルの各木を走査し、リーフノードのロジットを加算

## データベース操作仕様

該当なし（TensorFlowリソース変数として管理）

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| NotFound | リソース未初期化 | アンサンブルリソースが未初期化 | BoostedTreesCreateEnsembleを先に実行 |
| InvalidArgument | 形状不一致 | バッチサイズの不一致 | 入力テンソルのバッチサイズを統一 |
| InvalidArgument | 不正なsplit_type | inequality/equality以外 | 正しいsplit_typeを指定 |

### リトライ仕様

該当なし

## トランザクション仕様

ツリーアンサンブルはリソース変数として管理され、更新はアトミック。スタンプトークンにより整合性を保証。

## パフォーマンス要件

統計量集約はO(n * num_features * num_buckets)。推論はO(n * num_trees * tree_depth)。バケット化によりメモリ効率の高い計算を実現。

## セキュリティ考慮事項

特になし。

## 備考

- PruningModeクラス（Python）でプルーニングモードの文字列⇔整数変換を提供。
- QuantileAccumulatorクラスでバケット境界のチェックポイント保存・復元を管理。
- TreeEnsembleクラスでツリーアンサンブルのチェックポイント保存・復元を管理。
- BoostedTreesAggregateStatsはBoostedTreesMakeStatsSummaryの後継で、マルチ次元密テンソルとマルチクラスに対応。
- スパース版のOp（BoostedTreesSparseCalculateBestFeatureSplit、BoostedTreesSparseAggregateStats）も提供。

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造とリソース管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | boosted_trees_ops.py | `tensorflow/python/ops/boosted_trees_ops.py` | PruningMode, QuantileAccumulator, TreeEnsembleクラス |

**主要処理フロー**:
1. **50-63行目**: `PruningMode`クラス - NO_PRUNING(0), PRE_PRUNING(1), POST_PRUNING(2)の3モード定義
2. **95-163行目**: `QuantileAccumulator`クラス - バケット境界の管理。add_summaries→flush→get_bucket_boundariesのフロー
3. **210-311行目**: `TreeEnsemble`クラス - ツリーアンサンブルリソースの管理。serialize/deserializeでチェックポイント対応

**読解のコツ**: Python層は生成されたOpのラッパーと、チェックポイント対応のためのSaveableObject実装が中心。`gen_boosted_trees_ops`から自動生成されたOpをインポート（16-45行目）して使用している。

#### Step 2: Op定義（C++）を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | boosted_trees_ops.cc | `tensorflow/core/ops/boosted_trees_ops.cc` | 全Boosted Trees Opの定義 |

**主要処理フロー**:
- **31行目**: REGISTER_RESOURCE_HANDLE_OP(BoostedTreesEnsembleResource) - リソースハンドルOp
- **43-99行目**: BoostedTreesCalculateBestGainsPerFeature - 特徴量ごとの最適ゲイン計算
- **101-142行目**: BoostedTreesCalculateBestFeatureSplit - inequality/equality分割対応
- **304-344行目**: BoostedTreesMakeStatsSummary - 統計量集約（[features, splits, buckets, 2]形状）
- **348-392行目**: BoostedTreesAggregateStats - V2版統計量集約（マルチクラス対応）
- **455-482行目**: BoostedTreesPredict - 推論Op（バッチサイズ x logits_dimension出力）
- **566-617行目**: BoostedTreesUpdateEnsemble - アンサンブル更新
- **724行目**: REGISTER_RESOURCE_HANDLE_OP(BoostedTreesQuantileStreamResource) - 量子化リソース
- **844-864行目**: BoostedTreesBucketize - 特徴量のバケット化

#### Step 3: チェックポイント管理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | boosted_trees_ops.py | `tensorflow/python/ops/boosted_trees_ops.py` | _TreeEnsembleSavableとQuantileAccumulatorSaveable |

**主要処理フロー**:
- **66-92行目**: `QuantileAccumulatorSaveable` - バケット境界のシリアライゼーション
- **165-208行目**: `_TreeEnsembleSavable` - ツリーアンサンブルのstamp_token + serialized形式での保存・復元

### プログラム呼び出し階層図

```
Python Estimator API (BoostedTreesClassifier/Regressor)
    │
    ├─ TreeEnsemble (リソース管理)
    │      ├─ create_ensemble()
    │      ├─ get_states()
    │      ├─ serialize() / deserialize()
    │      └─ _TreeEnsembleSavable (チェックポイント)
    │
    ├─ QuantileAccumulator (量子化)
    │      ├─ add_summaries()
    │      ├─ flush()
    │      ├─ get_bucket_boundaries()
    │      └─ QuantileAccumulatorSaveable (チェックポイント)
    │
    ├─ 学習ループ
    │      ├─ BoostedTreesBucketize (特徴量バケット化)
    │      ├─ BoostedTreesAggregateStats (統計集約)
    │      ├─ BoostedTreesCalculateBestFeatureSplit (分割計算)
    │      ├─ BoostedTreesCenterBias (バイアス計算)
    │      └─ BoostedTreesUpdateEnsembleV2 (アンサンブル更新)
    │
    └─ 推論
           └─ BoostedTreesPredict (推論実行)
```

### データフロー図

```
[入力]                       [処理]                          [出力]

float_values ────────▶ QuantileSummaries ──▶ BucketBoundaries
                                                    │
float_values ────────▶ Bucketize ──────────▶ bucketized_features
                           │                         │
node_ids + gradients ──▶ AggregateStats ──▶ stats_summary
+ hessians                                          │
                                                    ▼
                     CalculateBestFeatureSplit ──▶ gains, thresholds
                                                    │
                     UpdateEnsembleV2 ──────────▶ 更新されたアンサンブル
                                                    │
bucketized_features ──▶ Predict ───────────────▶ logits
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| boosted_trees_ops.cc | `tensorflow/core/ops/boosted_trees_ops.cc` | ソース | 全Boosted Trees Op定義（C++） |
| boosted_trees_ops.py | `tensorflow/python/ops/boosted_trees_ops.py` | ソース | Python ラッパー、リソース管理クラス |
| gen_boosted_trees_ops.py | 自動生成 | ソース | 自動生成されたPython Op関数群 |
| common_shape_fns.h | `tensorflow/core/framework/common_shape_fns.h` | ヘッダー | 共通形状推論関数 |
| resource_mgr.h | `tensorflow/core/framework/resource_mgr.h` | ヘッダー | リソース管理フレームワーク |
